/**
  * @file <loop-functions/example/ExampleAggregationLoopFunc.cpp>
  *
  * @author Antoine Ligot - <aligot@ulb.ac.be>
  *
  * @package ARGoS3-AutoMoDe
  *
  * @license MIT License
  */
#include "mission.h"
/****************************************/
/***************************************
 Task 2. [Migration with obstacle]
*/


ChocolateMission6LoopFunction::ChocolateMission6LoopFunction() {
  m_cCoordSpot1 = CVector2(0.0,-1.05);
  m_cCoordSpot2 = CVector2(0.4125,-0.66);
  m_cCoordSpot3=CVector2(-0.4125,-0.66);


  m_cCoordSpot4 = CVector2(0.0,1.05);
  m_cCoordSpot5 = CVector2(0.3,0.66);
  m_cCoordSpot6=CVector2(-0.3,0.66);


  m_fObjectiveFunction = 0;
  m_cRegex = std::regex("epuck_?([0-9]+)_?([0-9]+)?");
  m_unNumberEdges=4;
  sidesize=1.5;
  reward=1.0;
  penalty=0.05;
  //
  //m_robotmin=m_unNumberRobots;
 // m_decreaseRobots=0;
  //numRobots=m_robotmin;
  //m_unScoreSpot = 0;
  //penalty=0;
}

/****************************************/
/****************************************/

ChocolateMission6LoopFunction::ChocolateMission6LoopFunction(const ChocolateMission6LoopFunction& orig) {}

/****************************************/
/****************************************/

ChocolateMission6LoopFunction::~ChocolateMission6LoopFunction() {}

/****************************************/
/****************************************/

void ChocolateMission6LoopFunction::Destroy() {}

/****************************************/
/****************************************/

Real ChocolateMission6LoopFunction::GetObjectiveFunction(){
   return m_fObjectiveFunction;
}

void ChocolateMission6LoopFunction::Reset(){
  m_fObjectiveFunction = 0;
  CoreLoopFunctions::Reset();
}


//UInt32 ChocolateMission6LoopFunction::GetNumRobots(){
 // return numRobots;
//}

/****************************************/
/****************************************/

argos::CColor ChocolateMission6LoopFunction::GetFloorColor(const argos::CVector2& c_position_on_plane) {
  CVector2 vCurrentPoint(c_position_on_plane.GetX(), c_position_on_plane.GetY());
  if (IsWithinTriangle(vCurrentPoint, m_cCoordSpot1, m_cCoordSpot2, m_cCoordSpot3)){
    return CColor::WHITE;
  }
  else 
       return CColor::GRAY50;
}


void ChocolateMission6LoopFunction::Init(TConfigurationNode& t_tree) {
  CoreLoopFunctions::Init(t_tree);
  CRadians fAngle=(2*CRadians::PI)/m_unNumberEdges;
 // CQuaternion angleWall;
  fRadius=InnerRadious();
  // Center
 // angleWall.FromEulerAngles(CRadians::PI_OVER_TWO, CRadians::ZERO, CRadians::ZERO);
  //m_pcBoxCenter = new CBoxEntity("wall_center",
  //    CVector3(0, m_cPositionShelter.GetY() - (m_fHeightShelter/2)- (0.05/2), 0.0),
     // angleWall,
    //  false,
     // CVector3(0.05, m_fWidthShelter+0.05, 0.2));
  //AddEntity(*m_pcBoxCenter);
  for(UInt32 i = 0; i < m_unNumberEdges; ++i) {
      //std::ostringstream id;
     // id << this->GetId() << ".wall_" << i;
      std::ostringstream id;
      id  << ".wall_" << i;
      pcWall = new CBoxEntity(id.str().c_str(), CVector3((fRadius * Cos(fAngle * i+CRadians::PI_OVER_FOUR)),
                                                                              (fRadius * Sin(fAngle * i+CRadians::PI_OVER_FOUR)),
                                                                              0),
                               CQuaternion().FromEulerAngles(-CRadians::PI +(fAngle * i)+CRadians::PI_OVER_FOUR,CRadians::ZERO,CRadians::ZERO),
                               false,
                               CVector3(0.01,sidesize,0.08),
                               0.2);
      AddEntity(*pcWall);
    }
}

Real ChocolateMission6LoopFunction::InnerRadious() {
       Real fInnerRadious = (sidesize) / (2 * Tan(CRadians::PI / m_unNumberEdges));
       return fInnerRadious;
}

void ChocolateMission6LoopFunction::PostStep() {
 //UInt32 score_temp = m_fObjectiveFunction;
  CSpace::TMapPerType& tEpuckMap = GetSpace().GetEntitiesByType("epuck");
  CVector2 cEpuckPosition(0,0);
  m_unScoreSpot=0;
  m_unScoreOutSpot=0;
  //penalty=0;
  UInt32 unId=0;
  for (CSpace::TMapPerType::iterator it = tEpuckMap.begin(); it != tEpuckMap.end(); ++it) {
    CEPuckEntity* pcEpuck = any_cast<CEPuckEntity*>(it->second);

    // expects the id to be in the following form: epuck{robotId} or epuck_{robotId}_{tagId} or epuck_{robotId}
    std::string strRobotId = pcEpuck->GetId();
    std::smatch cMatch;
    bool bMatchFound = std::regex_match(strRobotId, cMatch , m_cRegex);
    if (bMatchFound) {
      unId = std::stoi(cMatch[1].str());
    }

    //unId = atoi(strRobotId.c_str());
    cEpuckPosition.Set(pcEpuck->GetEmbodiedEntity().GetOriginAnchor().Position.GetX(),
                       pcEpuck->GetEmbodiedEntity().GetOriginAnchor().Position.GetY());

    if (IsWithinTriangle(cEpuckPosition, m_cCoordSpot1, m_cCoordSpot2, m_cCoordSpot3)){
         m_unScoreSpot++;
    }
    else {
         m_unScoreOutSpot++;
    }

    
  }

   if(m_unScoreSpot>=5) {
      m_fObjectiveFunction=m_fObjectiveFunction+reward;
      m_fObjectiveFunction=m_fObjectiveFunction - m_unScoreOutSpot*penalty;

      //LOG << m_fObjectiveFunction << std::endl;
      //break;
    }

    
    
}



void ChocolateMission6LoopFunction::PostExperiment() {
   LOG << "Score_objective:" << m_fObjectiveFunction << std::endl;
}

bool ChocolateMission6LoopFunction::IsPointInTri(CVector2& pt, CVector2& v1, CVector2& v2, CVector2& v3)
{
  Real TotalArea = CalcTriArea(v1, v2, v3);
  Real Area1 = CalcTriArea(pt, v2, v3);
  Real Area2 = CalcTriArea(pt, v1, v3);
  Real Area3 = CalcTriArea(pt, v1, v2);

  if((Area1 + Area2 + Area3) > TotalArea)
    return false;
  else
    return true;
}

Real ChocolateMission6LoopFunction::CalcTriArea(CVector2& v1, CVector2& v2, CVector2& v3)
{
  Real det = 0.0f;
  det = ((v1.GetX() - v3.GetX()) * (v2.GetY() - v3.GetY())) - ((v2.GetX() - v3.GetX()) * (v1.GetY() - v3.GetY()));
  return (det / 2.0f);
}



bool ChocolateMission6LoopFunction::IsWithinTriangle(CVector2& c_point_q, CVector2& c_point_a, CVector2& c_point_b, CVector2& c_point_c) {
  Real fAreaTriangle = AreaTriangle(c_point_a, c_point_b, c_point_c);
  Real fAreaABQ = AreaTriangle(c_point_a, c_point_b, c_point_q);
  Real fAreaBCQ = AreaTriangle(c_point_b, c_point_c, c_point_q);
  Real fAreaACQ = AreaTriangle(c_point_a, c_point_c, c_point_q);



 if (Abs(fAreaTriangle - (fAreaABQ + fAreaACQ + fAreaBCQ)) < 0.0001) {
    return true;
  } else {
    return false;
  }
}


Real ChocolateMission6LoopFunction::AreaTriangle(CVector2& c_point_a, CVector2& c_point_b, CVector2& c_point_c) {
  Real fArea = Abs(c_point_a.GetX()*(c_point_b.GetY()-c_point_c.GetY()) + c_point_b.GetX()*(c_point_c.GetY()-c_point_a.GetY()) + c_point_c.GetX()*(c_point_a.GetY()-c_point_b.GetY()))/2;
  return fArea;
}




CVector3 ChocolateMission6LoopFunction::GetRandomPosition() {
  Real a;
  Real b;
  Real temp;
  CVector2 position;

  //a = m_pcRng->Uniform(CRange<Real>(-0.3f, 0.3f));
  //b = m_pcRng->Uniform(CRange<Real>(0.4f, 1.0f));

  UInt32 unTrials = 0;
  // If b < a, swap them

  do {
  ++unTrials;
  //Real fPosX = b * m_fDistributionRadius * cos(2 * CRadians::PI.GetValue() * (a/b));
  //Real fPosY = b * m_fDistributionRadius * sin(2 * CRadians::PI.GetValue() * (a/b));
  a = m_pcRng->Uniform(CRange<Real>(-0.3f, 0.3f));
  b = m_pcRng->Uniform(CRange<Real>(0.4f, 1.0f));
  position=CVector2(a,b);
  std::cout << CVector3(a, b, 0) << std::endl; 
  } 
  while(!IsWithinTriangle(position, m_cCoordSpot4, m_cCoordSpot5, m_cCoordSpot6) && unTrials < 100);
 return CVector3(a, b, 0);
}


REGISTER_LOOP_FUNCTIONS(ChocolateMission6LoopFunction, "chocolate_mission6_loop_functions");
